local mods, actorCmds

return Def.ActorFrame {
	InitCommand = function(self)
	end,

	OnCommand = function(self)
		function m(beat,mod)
			table.insert(mods,{beat,mod});
		end
		
		function aC(beat,command)
			table.insert(actorCmds,{beat,command});
		end
		
		local screen = SCREENMAN:GetTopScreen()

		local null = self:GetChild('NullActorFrame')

		local p1 = screen:GetChild('PlayerP1')
		local p2 = screen:GetChild('PlayerP2') or null

		if not p1 then
			for i,v in pairs(screen:GetChild('')) do
				if tostring(v):find('Player') then
					p1 = v
					break
				end
			end
		end

		local players = {p1, p2}

		local p1state = GAMESTATE:GetPlayerState(PLAYER_1)
		local p2state = GAMESTATE:GetPlayerState(PLAYER_2)

		local arrowChomp = '*10 50% flip, *10 50% reverse'
		local arrowChompEnd = '*10 no flip, *10 no reverse'

		local hardTiny = function(percent)
			return '*99 ' .. percent .. '% tiny'
		end
		local noTiny = '*15 no tiny'

		mods = {
			{0, '*99 2.25x'},
			{4, '*99 200 beat'},
			{48.1, '*99 no centered'},
			{49.1, '*99 no tipsy'},
			{52, '*99 no drunk'},
			{84, '*99 no centered'},
			{108, '*4 invert'},
			{116, '*99 no invert'},
			{122, '*7 flip'},
			{130, '*7 -100 invert'},
			{140, '*7 no invert,*7 no flip'},
			{153, '*99 reverse'},
			{167, '*99 split'},
			{176, '*99 alternate'},
			{187, '*4 no reverse,*4 no split,*4 no alternate,*8 no beat'},
			{191, '*4 drunk,*2 wave,*2 bumpy'},
			{195, hardTiny(-150)},
			{195.25, noTiny},
			{195.75, hardTiny(-150)},
			{196, noTiny},
			{196.5, hardTiny(-150)},
			{196.75, noTiny},
			{199.5, hardTiny(-150)},
			{199.75, noTiny},
			{201, hardTiny(-150)},
			{201.25, noTiny},
			{202.5, hardTiny(-150)},
			{202.75, noTiny},
			{213, hardTiny(-150)},
			{213.25, noTiny},
			{213.75, hardTiny(-150)},
			{214, noTiny},
			{214.5, hardTiny(-150)},
			{214.75, noTiny},
			{215, arrowChomp},
			{217, arrowChompEnd},
			{219, '*99 dark,*99 stealth'},
			{220, '*99 no dark,*99 no stealth,*2 300 distant'},
			{225, '*10 overhead,*10 no drunk,*10 no wave,*10 no bumpy'},
			{260, '*4 reverse'},
			{264, '*4 no reverse'},
			{268, '*4 reverse'},
			{272, '*4 no reverse'},
			{276, '*0.3 -250 tiny'},
			{288, noTiny},
			{288.75, hardTiny(-150)},
			{289, noTiny},
			{289.5, hardTiny(-150)},
			{289.75, noTiny},
			{292, '*99 1000 beat,*99 drunk,*99 dark,*99 55 stealth'},
			{292.25, '*1000 no beat'},
			{320.1, '*99 no drunk,*99 no dark,*99 no stealth'},
			{324.1, '*99 no centered'},
			{332, '300 distant'},
			{340.1, '*99 overhead'},
			{348, '300 hallway'},
			{356, '*99 overhead,*99 250 beat'},
			{358, '*4 reverse'},
			{368, hardTiny(-150)},
			{368.25, noTiny},
			{368.75, hardTiny(-150)},
			{369, noTiny},
			{369.5, hardTiny(-150)},
			{369.75, noTiny},
			{370, hardTiny(-150)},
			{370.25, noTiny},
			{370.75, hardTiny(-150)},
			{371, noTiny},
			{371.5, hardTiny(-150)},
			{371.75, noTiny},
			{374, '*4 no reverse'},
			{384, hardTiny(-150)},
			{384.25, noTiny},
			{384.75, hardTiny(-150)},
			{385, noTiny},
			{385.5, hardTiny(-150)},
			{385.75, noTiny},
			{386, hardTiny(-150)},
			{386.25, noTiny},
			{386.75, hardTiny(-150)},
			{387, noTiny},
			{387.5, hardTiny(-150)},
			{387.75, noTiny},
			{417.5, '*4 500 drunk,*4 dark,*4 stealth'}
		}

centers={{44,47},{76,83},{320,323}}
		
for i,v in pairs(centers) do
    for beat=v[1],v[2] do
        m(beat+.25, '*7 300 centered')
		m(beat, '*99 no centered')
    end
end

for beat=48,48.5,1 do
	m(beat, '*20 250 tipsy')
	m(beat+.25, '*20 -250 tipsy')
	m(beat+.5, '*20 250 tipsy')
	m(beat+.75, '*20 -250 tipsy')
end

for beat=49,51,1 do
	m(beat, '*20 250 drunk')
	m(beat+.25, '*20 -250 drunk')
	m(beat+.5, '*20 250 drunk')
	m(beat+.75, '*20 -250 drunk')
end

minis8th={{324,326},{330,330.5},{340,342},{346,346.5}}

for i,v in pairs(minis8th) do
    for beat=v[1],v[2] do
        m(beat, '*99 200 mini')
		m(beat+.25, '*20 no mini')
		m(beat+.5, '*99 200 mini')
		m(beat+.75, '*20 no mini')
    end
end

minis4th={{327,328},{343,344}}

for i,v in pairs(minis4th) do
    for beat=v[1],v[2] do
        m(beat, '*99 200 mini')
		m(beat+.25, '*20 no mini')
    end
end

		local spinn = function()
			p1:spin():effectmagnitude(800, 0, 0)
			p2:spin():effectmagnitude(800, 0, 0)
		end

		local stopEffect = function()
			p1:stopeffect()
			p2:stopeffect()
		end

		local randomRota = function()
			for i=1, #players do
				players[i]
					:rotationz(math.random(45))
					:rotationy(math.random(45))
					:rotationx(math.random(45))
			end
		end

		local instaReset = function()
			for i=1, #players do
				players[i]
					:rotationz(0)
					:rotationy(0)
					:rotationx(0)
			end
		end

		local bounce = function()
			for i=1, #players do
				players[i]
					:bounce()
					:effectmagnitude(0, -45, 0)
					:effectperiod(0.25)
			end
		end

		actorCmds = {
			{60, randomRota},
			{62, randomRota},
			{68, randomRota},
			{84, instaReset},
			{84, spinn},
			{116, stopEffect},
			{116, instaReset},
			{260, bounce},
			{292, stopEffect}
		}
		
for beat=76,83,1 do
	aC(beat, randomRota)
end

		for i=#actorCmds, 1, -1 do
			if GAMESTATE:GetSongBeat() > actorCmds[i][1] then
				table.remove(actorCmds, i)
			end
		end

		p1:stopeffect()
		p2:stopeffect()

		local firstRun = true
		self:SetUpdateFunction(function(self, delta)
			local currentBeat = GAMESTATE:GetSongBeat()

			for i=1, #mods do
				local mod = mods[i]
				if not mod.done and currentBeat >= mod[1] then
					local modstr = table.concat({ unpack(mod, 2) }, ',')
					p1state:SetPlayerOptions('ModsLevel_Song', p1state:GetPlayerOptionsString('ModsLevel_Song')..','..modstr)
					p2state:SetPlayerOptions('ModsLevel_Song', p2state:GetPlayerOptionsString('ModsLevel_Song')..','..modstr)
					mod.done = true

					if not firstRun then
						break
					end
				end
			end

			for i=1, #actorCmds do
				local command = actorCmds[i]
				if not command.done and currentBeat > command[1] then
					command[2]()
					command.done = true
				end
			end
			
			for i=1,2 do
				SCREENMAN:GetTopScreen():GetChild('LifeP'..i):visible(false);
				SCREENMAN:GetTopScreen():GetChild('Overlay'):visible(false);
				SCREENMAN:GetTopScreen():GetChild('Underlay'):visible(false);
				SCREENMAN:GetTopScreen():GetChild('BPMDisplay'):visible(false);
			end

			if firstRun then
				p1:finishtweening()
				p2:finishtweening()
			end
			firstRun = false
		end)
	end,

	Def.Quad{ OnCommand = function(self) self:sleep(1000) end },
	Def.ActorFrame{ Name='NullActorFrame' },
}
